Images.MenuBG = LoadImage("Menu-BG.png");
Images.Selector = LoadImage("Finger.png");
Images.wepnIcon = LoadImage("Weapon-icon.png");
Images.armIcon = LoadImage("Arm-icon.png");
Images.headIcon = LoadImage("Head-icon.png");
Images.bodyIcon = LoadImage("Body-icon.png");
Images.accIcon = LoadImage("Acc-icon.png");

/*
There are multiple 'pages' to each screen.
The screens will use them for more than one thing.
The Order menu's first page is moving the screen
*/

function DrawBG()
{
	Images.MenuBG.blit(0, 0);
}

function OpenSubmenu()
{
	CheckSubmenu();
	RenderMap();
	FadeOut(200);
	Submenu(0);
	Submenu(1);
	Submenu(2);
	RenderMap();
	FadeIn(200);
}

function CheckSubmenu()
{
	Game.submenu.items[0].enabled = false;
	Game.submenu.items[1].enabled = false;
	Game.submenu.items[2].enabled = false;
	Game.submenu.items[3].enabled = false;
	if (Game.idolix.length == 0)
	{
		Game.submenu.items[4].enabled = false;
		Game.submenu.items[4].name = "";
	}
	Game.submenu.items[5].enabled = false;
	Game.submenu.items[6].enabled = false;
	Game.submenu.items[7].enabled = false;
}

function Submenu(page)
{
	if (page == 0)
	{
		for (var i = 0; i < 10; i ++)
		{
			DrawBG();
			PartyWindow(-220 + i * 23.6, 16);
			InfoWindow(227, 252 - i * 10.2, false);
			LocationWindow(-12 + i * 31.2, 212);
			Game.submenu.draw(227, -138 + i * 15.8, 73, 9);
			FlipScreen();
		}
		Game.submenu.opened = true;
	}
	else if (page == 1)
	{
		DrawBG();
		PartyWindow(16, 16);
		var s = Game.submenu.executeAlone(227, 20, 73, 9);
		if (s > 0 && s < 4)
		{
			DrawBG();
			PartyWindow(16, 16);
			InfoWindow();
			var character = SelectCharacter(16, 16);
		}
		switch (s)
		{
			case -2:
				OrderMenu(0);
				break;
			case 0:
				break;
			case 1:
				//AbilityMenu(character);
				break;
			case 2:
				//EquipmentMenu(character);
				break;
			case 3:
				//StatusMenu(character);
				break;
			case 4:
				break;
			case 5:
				break;
			case 6:
				break;
			case 7:
				break;
			case 8:
				Exit();
				break;
		}
		return;
	}
	else if (page == 2)
	{
		for (var i = 0; i < 10; i ++)
		{
			DrawBG();
			PartyWindow(16 - i * 23.6, 16);
			InfoWindow(227, 150 + i * 10.2, false);
			LocationWindow(300 - i * 31.2, 212);
			Game.submenu.draw(227, 20 - i * 15.8, 73, 9);
			FlipScreen();
		}
	}
}

function InventoryMenu()
{

}

function AbilityMenu(character)
{
	ApplyColorMask(Colors.Black);
	font.drawText(10, 10, "Character name: " + Game.party[character].name);
	FlipScreen();
	while (!IsKeyPressed(Game.cancel))
	{
	}
}

function OrderMenu(page)
{
	if (page == 0)
	{
		for (var i = 20; i > -1; i -= 94 / 20)
		{
			DrawBG();
			window.drawWindow(20 - i * 4.7, 20, 73, 10, true, "MENU");
			font.drawText(24 - i * 4.7, 20, "Order");
			PartyWindow(110 - i * 4.7, 16);
			InfoWindow(321 - i * 4.7, 150);
			Game.submenu.draw(321 - i * 4.7, 20, 73, 9, false);
			DrawCursor(110 - i * 4.7, 16);
			FlipScreen();
		}
		OrderMenu(1);
	}
	else if (page == 1)
	{
		DrawBG();
		window.drawWindow(20, 20, 73, 10, true, "MENU");
		font.drawText(24, 20, "Order");
		PartyWindow(110, 16);
		InfoWindow(321, 150);
		Game.submenu.draw(321, 20, 73, 9, false);
		var char1 = SelectCharacter(110, 16);
		if (char1 != -1 && char1 != -3)
		{
			DrawBG();
			window.drawWindow(20, 20, 73, 10, true, "MENU");
			font.drawText(24, 20, "Order");
			PartyWindow(110, 16);
			InfoWindow(321, 150);
			Game.submenu.draw(321, 20, 73, 9, false);
			DrawCursor(110, 16 + char1 * 47, true);
			var char2 = SelectCharacter(110, 16, char1);
			if (char2 == -1)
			{
				OrderMenu(1);
			}
			else if (Game.party[char1] == undefined && Game.party[char2] != undefined)
			{
				Game.party[char1] = Game.party[char2].clone();
				Game.party[char2] = undefined;
			}
			else if (Game.party[char2] == undefined && Game.party[char1] != undefined)
			{
				Game.party[char2] = Game.party[char1].clone();
				Game.party[char1] = undefined;
			}
			else if (char1 == char2)
			{
				if (Game.party[char1] != undefined)
				{
					if (Game.party[char1].position == "Front")
					{
						Game.party[char1].position = "Back";
					}
					else
						Game.party[char1].position = "Front";
				}
				else
					KeyPressed(false);
			}
			else
			{
				var tchar = Game.party[char1].clone();
				Game.party[char1] = Game.party[char2].clone();
				Game.party[char2] = tchar.clone();
			}
			OrderMenu(1);
		}
		else
			OrderMenu(2);
	}
	else if (page == 2)
	{
		for (var i = 0; i < 20; i += 94 / 20)
		{
			DrawBG();
			window.drawWindow(20 - i * 4.7, 20, 73, 10, true, "MENU");
			font.drawText(24 - i * 4.7, 20, "Order");
			PartyWindow(110 - i * 4.7, 16);
			InfoWindow(321 - i * 4.7, 150);
			Game.submenu.draw(321 - i * 4.7, 20, 73, 106);
			FlipScreen();
		}
		Submenu(1);
	}
}

function SelectCharacter(x, y, selection)
{
	var charSelect = new Menu(false);
	if (selection != undefined)
	{
		charSelect.selection = selection;
	}
	charSelect.addItem("");
	charSelect.addItem("");
	charSelect.addItem("");
	charSelect.addItem("");
	charSelect.spacing = 47;
	charSelect.returnSelection = true;
	return charSelect.executeAlone(x, y, 10, 240);
}

function PartyWindow(x, y)
{
	window.tborder.drawWindow(x, y, 194, 185);
	for (var i = 3; i > -1; i --)
	{
		window.partyWindow(x, y + i * 47, Game.party[i], true);
	}
	font.littleText(x + 4, y - 8, "CURRENT PARTY");
}

function LocationWindow(x, y)
{
	window.drawWindow(x - font.font.getStringWidth(Game.location), y, font.font.getStringWidth(Game.location), 10, true, "LOCATION");
	font.drawText(x - font.font.getStringWidth(Game.location), y, Game.location);
}

function InfoWindow(x, y, location)
{
	if (x == undefined)
	{
		x = 227;
		y = 150;
	}
	window.drawWindow(x, y, 73, 44, true, "TIME & FUNDS");
	font.drawText(x, y, "Play Time");
	font.drawText(x + 71, y + 12, Game.clock.getTime(), "right");
	font.drawText(x, y + 24, "Funds");
	font.drawText(x + 71, y + 36, Game.money+"$", "right");
	if (location == undefined)
	{
		LocationWindow(x + 73, y + 62);
	}
}

function EquipmentWindow(x, y, character, round)
{
	if (round != undefined)
	{
		window.drawWindow(x, y, 142, 67, true, "EQUIPMENT");
	}
	else
	{
		window.drawWindow(x, y, 142, 67, "Top", "EQUIPMENT");
	}
	Images.wepnIcon.blit(x, y);
	font.iconText(x + 14, y, character.items[0]);
	Images.armIcon.blit(x, y + 14);
	font.iconText(x + 14, y + 14, character.items[1]);
	Images.headIcon.blit(x, y + 28);
	font.iconText(x + 14, y + 28, character.items[2]);
	Images.bodyIcon.blit(x, y + 42);
	font.iconText(x + 14, y + 42, character.items[3]);
	Images.accIcon.blit(x, y + 56);
	font.iconText(x + 14, y + 56, character.items[4]);
}

function AttributeWindow(x, y, character)
{
	window.drawWindow(x, y, 124, 118, "Top", "ATTRIBUTES");
	font.drawText(x, y, "Strength");
	font.drawText(x + 122, y, character.strength, "right");
	font.drawText(x, y + 16, "Speed");
	font.drawText(x + 122, y + 16, character.speed, "right");
	font.drawText(x, y + 28, "Stamina");
	font.drawText(x + 122, y + 28, character.stamina, "right");
	font.drawText(x, y + 40, "Magic");
	font.drawText(x + 122, y + 40, character.magic, "right");
	font.drawText(x, y + 56, "Attack");
	font.drawText(x + 122, y + 56, GetAttack(character), "right");
	font.drawText(x, y + 68, "Defense");
	font.drawText(x + 122, y + 68, GetDefense(character), "right");
	font.drawText(x, y + 80, "Evade");
	font.drawText(x + 122, y + 80, GetEvade(character), "right");
	font.drawText(x, y + 92, "Magic Defense");
	font.drawText(x + 122, y + 92, GetMDefense(character), "right");
	font.drawText(x, y + 104, "Magic Evade");
	font.drawText(x + 122, y + 104, GetMEvade(character), "right");
}